load("semi_synthetic_exp.mat")
options.marker = "-square"
options.color_line = [46,117,198]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;

x = [100 300 500 800 1000 2000 3000];
options.x_axis = x;

subplot(4,4,1)
plot_areaerrorbar(squeeze(Error_F(1:end,:,16))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|C,D,I,O]')
xlim([100 3000])
ylim([0 0.30])
grid on

subplot(4,4,2)
plot_areaerrorbar(squeeze(Error_F(1:end,:,8))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(C),D,C,O]')
xlim([100 3000])
ylim([0 0.30])
grid on

subplot(4,4,3)
plot_areaerrorbar(squeeze(Error_F(1:end,:,12))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(D),C,I,O]')
xlim([100 3000])
ylim([0 0.30])
grid on

subplot(4,4,4)
plot_areaerrorbar(squeeze(Error_F(1:end,:,14))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(I),C,D,O]')
xlim([100 3000])
ylim([0 0.30])
grid on


subplot(4,4,5)
plot_areaerrorbar(squeeze(Error_F(1:end,:,15))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(O),C,D,I]')
xlim([100 3000])
ylim([0 0.30])
grid on


subplot(4,4,6)
plot_areaerrorbar(squeeze(Error_F(1:end,:,4))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(C,D),I,O]')
xlim([100 3000])
ylim([0 0.30])
grid on


subplot(4,4,7)
plot_areaerrorbar(squeeze(Error_F(1:end,:,6))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(C,I),D,O]')
xlim([100 3000])
ylim([0 0.30])
grid on

subplot(4,4,8)
plot_areaerrorbar(squeeze(Error_F(1:end,:,7))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(C,O),D,I]')
xlim([100 3000])
ylim([0 0.30])
grid on

subplot(4,4,9)
plot_areaerrorbar(squeeze(Error_F(1:end,:,10))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(D,I),C,O]')
xlim([100 3000])
ylim([0 0.30])
grid on

subplot(4,4,10)
plot_areaerrorbar(squeeze(Error_F(1:end,:,11))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(D,O),C,I]')
xlim([100 3000])
ylim([0 0.30])
grid on


subplot(4,4,11)
plot_areaerrorbar(squeeze(Error_F(1:end,:,13))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(I,O),C,D]')
xlim([100 3000])
ylim([0 0.30])
grid on


subplot(4,4,12)
plot_areaerrorbar(squeeze(Error_F(1:end,:,2))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(C,D,I),O]')
xlim([100 3000])
ylim([0 0.30])
grid on


subplot(4,4,13)
plot_areaerrorbar(squeeze(Error_F(1:end,:,5))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(C,I,O),D]')
xlim([100 3000])
ylim([0 0.30])
grid on


subplot(4,4,14)
plot_areaerrorbar(squeeze(Error_F(1:end,:,3))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(C,D,O),I]')
xlim([100 3000])
ylim([0 0.30])
grid on



subplot(4,4,15)
plot_areaerrorbar(squeeze(Error_F(1:end,:,9))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(D,I,O),C]')
xlim([100 3000])
ylim([0 0.30])
grid on



subplot(4,4,16)
plot_areaerrorbar(squeeze(Error_F(1:end,:,1))',options)
xlabel('Sample Size')
ylabel('MAE')
title('E[T|do(C,D,I,O)]')
xlim([100 3000])
ylim([0 0.30])
grid on



set(findobj(gcf,'type','axes'),'FontName','Arial','FontSize',12);
sgtitle('Mean absolute error (MAE) in estimating ATEs under various interventions for HEALTHCARE Bayesian Network')
% plot(S,EE,'linewidth',2)
% xlabel('Sample Size')
% ylabel('Percentage Absolute Error')
% title(' Maximum Error in Estimation of Covariance Matrix Entries ')
% grid on

% figure
% options.marker = "-square"
% options.color_line = [46,117,198]./255 ;
% options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
% load("data_inf_4_1.mat")
% x = [100 300 500 800 1000 2000 3000];
% options.x_axis = x;
% plot_areaerrorbar(Ed,options)
% xlabel("Sample Size")
% ylabel("Euclidean distance")
% ylim([0 1.2])
% xlim([100 3000])
% grid on